/* --------------------------------------------------------------
 auto_updater.js 2019-02-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.auto_updater = jse.libs.auto_updater || {};

(function(exports) {
	'use strict';
	
	// ------------------------------------------------------------------------
	// VARIABLES AND CONSTANTS
	// ------------------------------------------------------------------------
	
	/**
	 * Default options for controller,
	 *
	 * @type {object}
	 */
	const URLS = {
		processInstallation: '../gambio_store.php?do=processUpdate',
		permissionCheck: 'admin.php?do=AutoUpdaterAjax/checkPermission',
		uninstallTheme: 'admin.php?do=AutoUpdaterAjax/uninstallTheme',
	};
	
	// ------------------------------------------------------------------------
	// FUNCTIONS
	// ------------------------------------------------------------------------
	
	/**
	 * Installs a given update.
	 */
	exports.installGambioStorePackage = function(gambioStoreData, updateProgressCallback) {
		return new Promise((resolve, reject) => {
			const request = {
				url: URLS.processInstallation,
				data: {gambioStoreData: JSON.stringify(gambioStoreData)},
			};
			
			jse.libs.xhr.post(request).done(response => {
				if (response.success !== true) {
					return reject('Unexpected error');
				}
				
				updateProgressCallback(response);
				
				if (response.done === true) {
					return resolve();
				}
				
				exports.installGambioStorePackage(gambioStoreData, updateProgressCallback).then(() => {
					resolve();
				}).catch(error => {
					reject('Unexpected error');
				})
			}).fail(() => {
				reject('Install processing request failed');
			});
		});
	};
	
	/**
	 * Checks the file permissions for a given update.
	 */
	exports.checkGambioStorePackageFilePermissions = function(gambioStoreData) {
		return new Promise((resolve, reject) => {
			const request = {
				url: URLS.permissionCheck,
				data: {gambioStoreData: JSON.stringify(gambioStoreData)},
			};
			
			jse.libs.xhr.post(request).done(response => {
				if (response.success !== true || response.result !== true) {
					reject('Permission check failed');
				}
				resolve();
			}).fail(() => {
				reject('Permission check request failed');
			});
		});
	};
	
	/**
	 * Checks the file permissions for a given update.
	 */
	exports.uninstallTheme = function(themeName) {
		return new Promise((resolve, reject) => {
			const request = {
				url: URLS.uninstallTheme,
				data: {themeName: themeName}
			};
			
			jse.libs.xhr.post(request).done(response => {
				if (response.success !== true) {
					reject('Uninstall failed');
				}
				resolve();
			}).fail((data) => {
				reject(data);
			});
		});
	};
	
})(jse.libs.auto_updater);
